//#define SPRITE_CUSTOMIZE

/*
	Portable PC-Engine Emulator
	1998 by BERO bero@geocities.co.jp

    Modified 1998 by hmmx hmmx@geocities.co.jp
    Modified 2000 by U-TA npce@excite.co.jp
    Modified 2001 by BreezeKeeper npce@rising-force.net
*/


#include "stdinc.h"
#include "string.h"
#include <stdio.h>
#include <stdlib.h>
#include "pg.h"
#include "syscall.h"
#include "pce.h"
#include "m6502.h"

#include "hue_image.h"

#ifdef SOUND
#include "sound.h"
#endif //SOUND

#include "main.h"

#ifndef TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#define	ZW	64

//byte PopRAM[0x8000];
//byte ZBuf[ZW*256];

// ----------- Buffers -------------------------------------------
byte RAM[0x8000];
byte PopRAM[0x10000];
byte *Page[8],*ROMMap[512];

byte VRAM[VRAMSIZE];
byte vchange[VRAMSIZE / 32];
byte WRAM[0x2000];
byte DMYROM[0x2000];
byte IOAREA[0x2000];
byte PCM[0x10000];
IO    io;

short SPRAM[64*4];
unsigned long VRAM2[VRAMSIZE / sizeof(unsigned long)];

//---------------------------------------------------------------------
// PC EnginePalette gggrrrbbb = 512F(2^9) ݂B
// PaletteVCEŏ炵B
// 
//---------------------------------------------------------------------
PALFMT huePal[512];

int scanline=0;
byte populus = 0;


/* write */
M6502 M;

// ----------- Buffers -----------
// -------------------------------

//byte *IOAREA;

#if defined(USE_SPRITE_CACHE)
byte vchanges[VRAMSIZE/128];
unsigned long VRAMS[VRAMSIZE / sizeof(unsigned long)];
#endif //defined(USE_SPRITE_CACHE)


byte *ROM;
int ROM_size;
//extern int Debug,vmode;
int Country;
int IPeriod;
int BaseClock = 7160000, UPeriod = 0;
int OrigBaseClock = 7160000;
int TimerCount,CycleOld;
int TimerPeriod;
int scanlines_per_frame  = 263;
int prevline;

#define MinLine	io.minline
#define MaxLine io.maxline
//int MinLine = 0,MaxLine = 255;
#define MAXDISP	227
byte BGONSwitch = 1, SPONSwitch = 1;
//char *cart_name;
byte sf2ce = 0;

// ----------- Buffers -----------
int scroll = 0;
int skip_next_frame = 0;

//extern char	*pCartName;

//#define ScrollX	io.scroll_x
//#define ScrollY io.scroll_y

#define	VRR	2
int ScrollYDiff;
int	oldScrollX;
int	oldScrollY;
int	oldScrollYDiff;

typedef struct {
	short y,x,no,atr;
} SPR;


int CheckSprites(void);
int JoyStick(short *JS);

void  IO_write(word A,byte V);
byte  IO_read(word A);
void RefreshLine(int Y1,int Y2);
void RefreshSprite(int Y1,int Y2);
void RefreshScreen(void);

void bank_set(byte P,byte V)
{
    if (V>=ROM_size && V<0xF7) {
        //	printf("ignore bank set %x:%02x",P,V);
        //	TrashMachine();
        //	exit(-1);
    }
    if (ROMMap[V]==IOAREA)
      Page[P]=IOAREA;
    else
      Page[P]=ROMMap[V]-P*0x2000;
    //	IsROM[P] = (V < 0xF7);
}

byte _Rd6502(word A)
{
    if(Page[A>>13]!=IOAREA) return Page[A>>13][A];
    else return IO_read(A);
}

void _Wr6502(word A,byte V)
{
    if(sf2ce) {
        if (Page[A>>13] == IOAREA) {
            IO_write (A, V);
        }
        else if ((A & 0x1ffc)==0x1ff0) {
            /* support for SF2CE silliness */
            int i;
            ROMMap[0x40] = ROMMap[0] + 0x80000;
            ROMMap[0x40] += (A & 3) * 0x80000;
            
            for (i = 0x41; i <= 0x7f; i++) {
                ROMMap[i] = ROMMap[i - 1] + 0x2000;
            }
        } else {
            Page[A >> 13][A] = V;
        }
    } else {
        if (Page[A>>13]!=IOAREA) {
            Page[A>>13][A]=V;
        }
        else IO_write(A,V);
    }
}


void  IO_write(word A,byte V)
{
	switch(A&0x1C00) {
      case 0x0000: VDC_write(A,V); break; // VDC 
      case 0x0400: VCE_write(A,V); break; // VCE
#ifdef SOUND
      case 0x0800: PSG_write(A,V); break; // PSG
#endif
#ifdef CDEMUATION
      case 0x1800: CD_write(A,V);  break; // CDROM
#endif//CDEMULATION

      case 0x0c00:	/* timer */
		//TRACE("Timer Access: A=%X,V=%X\n", A, V);
		switch(A&1){
		case 0: io.timer_reload = V&127; return;
		case 1: 
			V&=1;
			if (V && !io.timer_start)
				io.timer_counter = io.timer_reload;
			io.timer_start = V;
			return;
		}
		break;

	case 0x1000:	/* joypad */
		io.joy_select = V&1;
		if (V&2) io.joy_counter = 0;
		return;

	case 0x1400:	/* IRQ */
		switch(A&3){
		case 2: io.irq_mask = V;/*TRACE("irq_mask = %02X\n", V);*/ return;
		case 3: io.irq_status= (io.irq_status&~TIRQ)|(V&0xF8); return;
		}
		break;
        
	}
	//TRACE("ignore I/O write %04x,%02x\n",A,V);
//	DebugDumpTrace(4, TRUE);
}


/* read */
byte IO_read(word A)
{
    byte ret;
    //printf("r%04x ",A&0x3FFF);
    switch(A&0x1CC0){
      case 0x0000: return VDC_read(A);  // VDC
      case 0x0400: return VCE_read(A);  // VCE
#ifdef SOUND
      case 0x0800: return PSG_read(A);  // PSG
#endif
#ifdef CDEMULATION
      case 0x1800:  return CD_read(A);  // CDROM
#endif//CDEMULATION

      case 0x0c00:	/* timer */
        switch(A&1){
          case 0:
            return io.timer_counter;
        }
        break;
        
      case 0x1000: { /* joypad */
        ret = (io.JOY[io.joy_counter]>>io.shiftmode[io.joy_counter])^0xff;
        if (io.joy_select&1) ret>>=4;
        else {
            ret&=15;
            if(io.JOY[io.joy_counter] & 0xf000) {
                io.shiftmode[io.joy_counter] = 8 - io.shiftmode[io.joy_counter];
            }
            io.joy_counter=(io.joy_counter+1)%5;
        }
        return ret; // |Country; /* country 0:JPN 1=US */
      }
      case 0x1400:	/* IRQ */
        switch(A&3){
          case 2: return io.irq_mask;
          case 3: ret = io.irq_status;io.irq_status=0;return ret;
        }
        break;
        
      case 0x18C0:		// Memory management ?
		switch (A & 15) {
          case 5:
          case 1:  return 0xAA;
          case 2:
          case 6:  return 0x55;
          case 3:
          case 7:  return 0x03;
            // case 15: // ACD support ?
            //  return 0x51;
        }
        break;
        
    }
	//TRACE("ignore I/O read %04x\n",A);
//	DebugDumpFp(4, TRUE);
	return NODATA;
}


//-----------------------------------------------------------------------------
// 
// PXLC`悷^C~OŎsۂ֐
// ʂɍlΖ炩ɒxꍇӊO͂PbԂ60s֐
// 
//-----------------------------------------------------------------------------
byte Loop6502(M6502 *R)
{
	static int UCount = 0;
//	static int ACount = 0;
	int ret;
	static int skip_frame;
	//printf("PC:%04x ",R->PC.W);

    int dispmin = (MaxLine-MinLine>MAXDISP ? MinLine+((MaxLine-MinLine-MAXDISP+1)>>1) : MinLine);
    int dispmax = (MaxLine-MinLine>MAXDISP ? MaxLine-((MaxLine-MinLine-MAXDISP+1)>>1) : MaxLine);

	scanline=(scanline+1)%scanlines_per_frame;
    
	//printf("scan %d\n",scanline);
	ret = INT_NONE;
	io.vdc_status&=~VDC_RasHit;

	if (scanline>MaxLine) {
		io.vdc_status|=VDC_InVBlank;
	}

//	if (scanline==MinLine+scanlines_per_frame-1)
//	else
    
    // \̈̂PCڂƂ̏
	if (scanline==MinLine) {
        
#ifdef SOUND
        SoundProcessing();
#endif // SOUND
        
        io.vdc_status&=~VDC_InVBlank;
		prevline=dispmin;
		ScrollYDiff = 0;
		oldScrollYDiff = 0;
		skip_frame = skip_next_frame;
		skip_next_frame = 0;
//		if (io.vdc_iswrite_h)
//		{
//			io.vdc_iswrite_h = 0;
//			ScrollY = io.VDC[BYR].W;
//		}
//		TRACE("\nFirstLine\n");
	}else
    // ŏICƂ̏
	if (scanline==MaxLine) {
        
		if (CheckSprites()) io.vdc_status|=VDC_SpHit;
		else io.vdc_status&=~VDC_SpHit;
        
		if (UCount) UCount--;
		else if (!skip_frame) {
			if (prevline<dispmax) {
				RefreshLine(prevline,dispmax);
				if (SpriteON && SPONSwitch) {
					RefreshSprite(prevline,dispmax+1);
				}
			}
			prevline=dispmax+1;
			UCount=UPeriod;
			RefreshScreen();
		}
	}

    // `XLC͈͓̏
	if (scanline>=MinLine && scanline<=MaxLine) {
		if (scanline==(io.VDC[RCR].W&1023)-64) {
			if (RasHitON && !UCount && dispmin<=scanline && scanline<=dispmax && !skip_frame) {
				if (prevline<dispmax) {
                    // PsۂfX
					RefreshLine(prevline,scanline-1);
					if (SpriteON && SPONSwitch) {
						RefreshSprite(prevline,scanline);
					}
				}
				prevline=scanline;
			}
			io.vdc_status|=VDC_RasHit;
			if (RasHitON) {
				//TRACE("rcr=%d\n", scanline);
				ret = INT_IRQ;
			}
		} else if (scroll) {
			if (scanline-1>prevline && !UCount && !skip_frame) {
				int	tmpScrollX, tmpScrollY, tmpScrollYDiff;
				tmpScrollX=ScrollX;
				tmpScrollY=ScrollY;
				tmpScrollYDiff=ScrollYDiff;
				ScrollX=oldScrollX;
				ScrollY=oldScrollY;
				ScrollYDiff=oldScrollYDiff;

                // PC`悷ہH
				RefreshLine(prevline,scanline-2);

				if (SpriteON && SPONSwitch) {
					RefreshSprite(prevline,scanline-1);
				}

				prevline=scanline-1;
				ScrollX = tmpScrollX;
				ScrollY = tmpScrollY;
				ScrollYDiff = tmpScrollYDiff;
			}
		}
	} else {
		int rcr = (io.VDC[RCR].W&1023)-64;

		if (scanline==rcr){
//			ScrollYDiff = scanline;
			if (RasHitON) {
				//TRACE("rcr=%d\n", scanline);
				io.vdc_status |= VDC_RasHit;
				ret = INT_IRQ;
			}
		}
	}
    
	scroll=0;

    // ŏIC`悵̃^C~OŎs镔
	if (scanline==MaxLine+1) {
//	if (scanline==scanlines_per_frame-63) {
		int result=JoyStick(io.JOY);
		if (result&0x10000) {
			return INT_QUIT;
		}

		/* VRAM to SATB DMA */
		if (io.vdc_satb==1 || io.VDC[DCR].W&0x0010) {
#if 1       // DMAfinish=true. int enableȂINTĂ
            __memcpy4(SPRAM,VRAM+io.VDC[SATB].W*2,512/4);
            io.vdc_status|=VDC_SATBfinish;
            io.vdc_satb=0;
			if (SATBIntON) {
				ret = INT_IRQ;
			}
#else      // ǉCł̓L[񂩂
            __memcpy4(SPRAM,VRAM+io.VDC[SATB].W*2,512/4); // <= ǉ
            io.vdc_status=~VDC_SATBfinish;
            io.vdc_satb=1;
#endif
		}
		if (ret==INT_IRQ) {
			io.vdc_pendvsync = 1;
		}
		else {
			//TRACE("vsync\n");
			//io.vdc_status|=VDC_InVBlank;
			if (VBlankON) {
				//TRACE("vsync=%d\n", scanline);
				ret = INT_IRQ;
			}
		}
	}
	else 
	if (scanline==min(MaxLine+5, scanlines_per_frame-1)) {
        if (io.vdc_satb) {
	        __memcpy4(SPRAM,VRAM+io.VDC[SATB].W*2,512/4);
			io.vdc_status|=VDC_SATBfinish;
			io.vdc_satb = 0;
			if (SATBIntON) {
				//TRACE("SATB=%d\n", scanline);
				ret = INT_IRQ;
			}
/*		} else {
			io.vdc_status&=~VDC_SATBfinish;
			io.vdc_satb = 0;
*/		}
	} else if (io.vdc_pendvsync && ret!=INT_IRQ) {
		io.vdc_pendvsync = 0;
		//io.vdc_status|=VDC_InVBlank;
		if (VBlankON) {
			//TRACE("vsync=%d\n", scanline);
			ret = INT_IRQ;
		}
	}
	if (ret == INT_IRQ) {
		if (!(io.irq_mask&IRQ1)) {
			io.irq_status|=IRQ1;
			//if (io.vdc_status&0x20)
			//TRACE("status=%02X\n", io.vdc_status);
			//TRACE("irq:scan %d\n ",scanline);
			return ret;
		}
	}
	return INT_NONE;
}

byte TimerInt(M6502 *R)
{
	if (io.timer_start) {
		io.timer_counter--;
		if (io.timer_counter > 128) {
			io.timer_counter = io.timer_reload;
			//io.irq_status &= ~TIRQ;
			if (!(io.irq_mask&TIRQ)) {
				io.irq_status |= TIRQ;
				//TRACE("tirq=%d\n",scanline);
				//TRACE("tirq\n");
				return INT_TIMER;
			}
		}
	}
	return INT_NONE;
}

/*
	Hit Chesk Sprite#0 and others
*/
int CheckSprites(void)
{
    register int i,x,y,w,h;
    SPR *spr = (SPR*)SPRAM;
    int x0 = spr->x;
    int y0 = spr->y;
	int w0 = (((spr->atr>>8 )&1)+1)*16;
	int h0 = (((spr->atr>>12)&3)+1)*16;
	spr++;
	for(i=1;i<64;i++,spr++) {
		x = spr->x;
		y = spr->y;
		w = (((spr->atr>>8 )&1)+1)*16;
		h = (((spr->atr>>12)&3)+1)*16;
		if ((x<x0+w0)&&(x+w>x0)&&(y<y0+h0)&&(y+h>y0)) return TRUE;
	}
	return FALSE;
}

static void plane2pixel(int no)
{
    register unsigned long M;
    register unsigned long L;
    register byte *C = VRAM+no*32;
    register unsigned long *C2=VRAM2+no*8;
    register int j;

    for(j=0;j<8;j++) {
        M=C[0];
        L =((M&0x88)>>3)|((M&0x44)<<6)|((M&0x22)<<15)|((M&0x11)<<24);
        M=C[1];
        L|=((M&0x88)>>2)|((M&0x44)<<7)|((M&0x22)<<16)|((M&0x11)<<25);
        M=C[16];
        L|=((M&0x88)>>1)|((M&0x44)<<8)|((M&0x22)<<17)|((M&0x11)<<26);
        M=C[17];
        L|=((M&0x88))|((M&0x44)<<9)|((M&0x22)<<18)|((M&0x11)<<27);
        C2[0] = L; //37261504

        C+=2;
        C2++;
    }
}

#if defined(USE_SPRITE_CACHE)
static void sprite2pixel(int no)
{
    register int i;
    register byte M;
    register byte *C=&VRAM[no*128];
    register unsigned long *C2=&VRAMS[no*32];
    register long L;

	for(i=0;i<32;i++,C++,C2++){
		M=C[0];
		L =((M&0x88)>>3)|((M&0x44)<<6)|((M&0x22)<<15)|((M&0x11)<<24);
		M=C[32];
		L|=((M&0x88)>>2)|((M&0x44)<<7)|((M&0x22)<<16)|((M&0x11)<<25);
		M=C[64];
		L|=((M&0x88)>>1)|((M&0x44)<<8)|((M&0x22)<<17)|((M&0x11)<<26);
		M=C[96];
		L|=((M&0x88))|((M&0x44)<<9)|((M&0x22)<<18)|((M&0x11)<<27);
		C2[0]=L;
	}
}
#else //defined(USE_SPRITE_CACHE)
static long sp2pixel(byte *C)
{
    register long L;
    register byte M;
    M=C[0];
    L =((M&0x88)>>3)|((M&0x44)<<6)|((M&0x22)<<15)|((M&0x11)<<24);
    M=C[32];
    L|=((M&0x88)>>2)|((M&0x44)<<7)|((M&0x22)<<16)|((M&0x11)<<25);
    M=C[64];
    L|=((M&0x88)>>1)|((M&0x44)<<8)|((M&0x22)<<17)|((M&0x11)<<26);
    M=C[96];
    L|=((M&0x88))|((M&0x44)<<9)|((M&0x22)<<18)|((M&0x11)<<27);
	return L;
}
#endif //defined(USE_SPRITE_CACHE)

PALFMT *XBuf;

#define	PAL(c)	R[c]
#define	SPal	(huePal+256)
#define	FC_W	io.screen_w
#define	FC_H	256

void RefreshLine(int Y1,int Y2)
{
    int i;
    int X1,XW,Line;
    int x,y,h,offset;
	PALFMT *PP;//,*ZP;
    //TRACE("%d-%d,Scroll=%d\n",Y1,Y2,ScrollY-ScrollYDiff);
	Y2++;

    PP=(PALFMT*)XBuf+WIDTH*(HEIGHT-FC_H)/2+(WIDTH-FC_W)/2+WIDTH*Y1;
    
    if(!ScreenON || !BGONSwitch) {
        WORD *dst = (WORD*)XBuf+((HEIGHT-FC_H)/2+Y1)*WIDTH;
        for(i=0;i<(Y2-Y1)*WIDTH;i++) { *dst++ = huePal[0]; }
    }
    else {
        //TRACE("ScrollY=%d,diff=%d\n", ScrollY, ScrollYDiff);
        //TRACE("ScrollX=%d\n", ScrollX);
        y = Y1+ScrollY-ScrollYDiff;
        offset = y&7;
        h = 8-offset;
        if (h>Y2-Y1) h=Y2-Y1;
        y>>=3;
        PP-=ScrollX&7;
        XW=io.screen_w/8+1;
        //	Shift = ScrollX&7;
        //	{byte *Z=ZBuf+Y1*ZW;
        //	for(Line=Y1;Line<Y2;Line++,Z+=ZW) Z[0]=0;
        //	}
        
        for(Line=Y1;Line<Y2;y++) {
            //    ZP = ZBuf+Line*ZW;
            x = ScrollX/8;
            y &= io.bg_h-1;
            for(X1=0;X1<XW;X1++,x++,PP+=8/*,ZP++*/){
                PALFMT *R,*P;
                byte *C;//,*Z;
                unsigned long *C2;
                int no,i;
                x&=io.bg_w-1;
                no = ((word*)VRAM)[x+y*io.bg_w];
                R = &huePal[(no>>12)*16];
                no&=0xFFF;
                if (vchange[no]) { vchange[no]=0; plane2pixel(no);}
                C2 = &VRAM2[no*8+offset];
                C = &VRAM[no*32+offset*2];
                P = PP;
                //		Z = ZP;
                for(i=0;i<h;i++) {
                    register unsigned long L=C2[0];
                    P[0]=PAL((L>> 4)&15);
                    P[1]=PAL((L>>12)&15);
                    P[2]=PAL((L>>20)&15);
                    P[3]=PAL((L>>28)   );
                    P[4]=PAL((L    )&15);
                    P[5]=PAL((L>> 8)&15);
                    P[6]=PAL((L>>16)&15);
                    P[7]=PAL((L>>24)&15);
                    P+=WIDTH;
                    C2++;
                    C+=2;
                }
            }
            Line+=h;
            PP+=WIDTH*h-XW*8;
            offset = 0;
            h = Y2-Line;
            if (h>8) h=8;
        }
    }
}

#define	V_FLIP	0x8000
#define	H_FLIP	0x0800
#define	SPBG	0x80
#define	CGX		0x100


#ifdef SPRITE_CUSTOMIZE

static void PutSprite_hflip(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,int hflip)
{
	register int i,J;
	unsigned long L[2];
    
	for(i=0;i<h;i++) {
        J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];
        if(J) {
            int sft[8]={4,12,20,28,0,8,16,24};
            int mask = 0x08000;
            int cnt,in,pos;
            
#if defined(USE_SPRITE_CACHE)
            L[1] = C2[0];
            L[0] = C2[1];
#else //defined(USE_SPRITE_CACHE)
            L[1] = sp2pixel(C);
            L[0] = sp2pixel(C+1);
#endif //defined(USE_SPRITE_CACHE)

            if(hflip==0) { in= 1; pos= 0; }
            else         { in=-1; pos=15; }

            for(cnt=0;cnt<16;cnt++) {
                if(J & mask) P[pos] = R[(L[cnt>>3]>>sft[cnt&7])&0xf];
                mask = mask >> 1;
                pos += in;
            }
        }

        C2+=inc;
        C+=inc;
        P+=WIDTH;
    }
}

#else // SPRITE_CUSTOMIZE

static void PutSprite(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc)
{
	register int i,J;
	register unsigned long L0,L1;
    
	for(i=0;i<h;i++) {

        J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];
        
        if(J) {
#if defined(USE_SPRITE_CACHE)
            L0 = C2[0];
            L1 = C2[1];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C);
            L1 = sp2pixel(C+1);
#endif //defined(USE_SPRITE_CACHE)

            if(J&0xFF00) {
                if(J&0x8000) P[0] =PAL((L1>> 4)&15);
                if(J&0x4000) P[1] =PAL((L1>>12)&15);
                if(J&0x2000) P[2] =PAL((L1>>20)&15);
                if(J&0x1000) P[3] =PAL((L1>>28)   );
                if(J&0x0800) P[4] =PAL((L1    )&15);
                if(J&0x0400) P[5] =PAL((L1>> 8)&15);
                if(J&0x0200) P[6] =PAL((L1>>16)&15);
                if(J&0x0100) P[7] =PAL((L1>>24)&15);
            }

            if(J&0x00FF) {
                if(J&0x0080) P[8] =PAL((L0>> 4)&15);
                if(J&0x0040) P[9] =PAL((L0>>12)&15);
                if(J&0x0020) P[10]=PAL((L0>>20)&15);
                if(J&0x0010) P[11]=PAL((L0>>28)   );
                if(J&0x0008) P[12]=PAL((L0    )&15);
                if(J&0x0004) P[13]=PAL((L0>> 8)&15);
                if(J&0x0002) P[14]=PAL((L0>>16)&15);
                if(J&0x0001) P[15]=PAL((L0>>24)&15);
            }
        }

        C2+=inc;
        C+=inc;
        P+=WIDTH;
	}
}

static void PutSpriteHflip(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc)
{
	register int i,J;
	register unsigned long L0,L1;
    
	for(i=0;i<h;i++) {
		J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];
        if(J) {
#if defined(USE_SPRITE_CACHE)
            L0 = C2[0];
            L1 = C2[1];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C);
            L1 = sp2pixel(C+1);
#endif //defined(USE_SPRITE_CACHE)

            if (J&0x00FF) {
                if (J&0x0001) P[0]=PAL((L0>>24)&15);
                if (J&0x0002) P[1]=PAL((L0>>16)&15);
                if (J&0x0004) P[2]=PAL((L0>> 8)&15);
                if (J&0x0008) P[3]=PAL((L0    )&15);
                if (J&0x0010) P[4]=PAL((L0>>28));
                if (J&0x0020) P[5]=PAL((L0>>20)&15);
                if (J&0x0040) P[6]=PAL((L0>>12)&15);
                if (J&0x0080) P[7]=PAL((L0>> 4)&15);
            }

            if(J&0xFF00) {
                if (J&0x0100) P[8] =PAL((L1>>24)&15);
                if (J&0x0200) P[9] =PAL((L1>>16)&15);
                if (J&0x0400) P[10]=PAL((L1>> 8)&15);
                if (J&0x0800) P[11]=PAL((L1    )&15);
                if (J&0x1000) P[12]=PAL((L1>>28)   );
                if (J&0x2000) P[13]=PAL((L1>>20)&15);
                if (J&0x4000) P[14]=PAL((L1>>12)&15);
                if (J&0x8000) P[15]=PAL((L1>> 4)&15);
            }
        }
        
        C2+=inc;
        C+=inc;
        
        P+=WIDTH;
	}
}
#endif//SPRITE_CUSTOMIZE


//******************************************************************************
#ifdef SPRITE_CUSTOMIZE

static void PutSpriteBack_hflip(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,
						  int cx,int cy,int xoffset,int yoffset,int hflip)
{
    register int i,J;
    register unsigned long L0,L1;
    register unsigned long M,MJ;
	int tx;
	byte *CC1=0,*CC2=0,*CC3=0;
	int no;

	yoffset+=8;	// ŏifɓ
    cy--;
    
	for(i=0;i<h;i++,C+=inc,C2+=inc,P+=WIDTH,yoffset++,CC1+=2,CC2+=2,CC3+=2) {
		if (yoffset>=8) {
			cy++;
			cy = cy&(io.bg_h-1);
			yoffset -= 8;

			no = ((word*)VRAM)[cx+cy*io.bg_w];
			no&=0xFFF;
			CC1 = &VRAM[no*32+yoffset*2];
			tx=(cx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			no&=0xFFF;
			CC2 = &VRAM[no*32+yoffset*2];
			tx=(tx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			no&=0xFFF;
			CC3 = &VRAM[no*32+yoffset*2];
		}

		M=CC1[0]|CC1[1]|CC1[16]|CC1[17];
		M=(M<<8)|CC2[0]|CC2[1]|CC2[16]|CC2[17];
		M=(M<<8)|CC3[0]|CC3[1]|CC3[16]|CC3[17];
		M>>=(8-xoffset);

        J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];
        
        if(J) {
            
#if defined(USE_SPRITE_CACHE)
            L0 = C2[0];
            L1 = C2[1];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C);
            L1 = sp2pixel(C+1);
#endif //defined(USE_SPRITE_CACHE)

            if(hflip) {
                MJ= M | J;
                if((MJ&0x8001)==0x0001) P[0] = PAL((L0>>24)&15);
                if((MJ&0x4002)==0x0002) P[1] = PAL((L0>>16)&15);
                if((MJ&0x2004)==0x0004) P[2] = PAL((L0>> 8)&15);
                if((MJ&0x1008)==0x0008) P[3] = PAL((L0    )&15);
                if((MJ&0x0810)==0x0010) P[4] = PAL((L0>>28)&15);
                if((MJ&0x0420)==0x0020) P[5] = PAL((L0>>20)&15);
                if((MJ&0x0240)==0x0040) P[6] = PAL((L0>>12)&15);
                if((MJ&0x0180)==0x0080) P[7] = PAL((L0>> 4)&15);
                if((MJ&0x0180)==0x0100) P[8] = PAL((L1>>24)&15);
                if((MJ&0x0240)==0x0200) P[9] = PAL((L1>>16)&15);
                if((MJ&0x0420)==0x0400) P[10]= PAL((L1>> 8)&15);
                if((MJ&0x0810)==0x0800) P[11]= PAL((L1    )&15);
                if((MJ&0x1008)==0x1000) P[12]= PAL((L1>>28)&15);
                if((MJ&0x2004)==0x2000) P[13]= PAL((L1>>20)&15);
                if((MJ&0x4002)==0x4000) P[14]= PAL((L1>>12)&15);
                if((MJ&0x8001)==0x8000) P[15]= PAL((L1>> 4)&15);
            } else {
                MJ = (~M) & J;
                if(MJ&0x8000)           P[0] = PAL((L1>> 4)&15);
                if(MJ&0x4000)           P[1] = PAL((L1>>12)&15);
                if(MJ&0x2000)           P[2] = PAL((L1>>20)&15);
                if(MJ&0x1000)           P[3] = PAL((L1>>28)&15);
                if(MJ&0x0800)           P[4] = PAL((L1    )&15);
                if(MJ&0x0400)           P[5] = PAL((L1>> 8)&15);
                if(MJ&0x0200)           P[6] = PAL((L1>>16)&15);
                if(MJ&0x0100)           P[7] = PAL((L1>>24)&15);
                if(MJ&0x0080)           P[8 ]= PAL((L0>> 4)&15);
                if(MJ&0x0040)           P[9 ]= PAL((L0>>12)&15);
                if(MJ&0x0020)           P[10]= PAL((L0>>20)&15);
                if(MJ&0x0010)           P[11]= PAL((L0>>28)&15);
                if(MJ&0x0008)           P[12]= PAL((L0    )&15);
                if(MJ&0x0004)           P[13]= PAL((L0>> 8)&15);
                if(MJ&0x0002)           P[14]= PAL((L0>>16)&15);
                if(MJ&0x0001)           P[15]= PAL((L0>>24)&15);
            }
        }
    }
}

//******************************************************************************
#else//SPRITE_CUSTOMIZE
static void PutSpriteBack(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,
						  int cx,int cy,int xoffset,int yoffset)
{
    register int i,J;
    register unsigned long L0,L1;
    register unsigned long M;
	int tx;
//	byte *CC1,*CC2,*CC3;
	byte *CC1=0,*CC2=0,*CC3=0;
	int no;

	yoffset+=8;	// ŏifɓ
	cy--;
	for(i=0;i<h;i++,C+=inc,C2+=inc,P+=WIDTH,yoffset++,CC1+=2,CC2+=2,CC3+=2) {
		if (yoffset>=8) {
			cy++;
			cy = cy&(io.bg_h-1);
			yoffset -= 8;

			no = ((word*)VRAM)[cx+cy*io.bg_w];
			no&=0xFFF;
			CC1 = &VRAM[no*32+yoffset*2];
			tx=(cx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			no&=0xFFF;
			CC2 = &VRAM[no*32+yoffset*2];
			tx=(tx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			no&=0xFFF;
			CC3 = &VRAM[no*32+yoffset*2];
		}

		M=CC1[0]|CC1[1]|CC1[16]|CC1[17];
		M=(M<<8)|CC2[0]|CC2[1]|CC2[16]|CC2[17];
		M=(M<<8)|CC3[0]|CC3[1]|CC3[16]|CC3[17];
		M>>=(8-xoffset);
		M=~M;

		J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];
        
        if(J) {
#if defined(USE_SPRITE_CACHE)
            L1 = C2[1];
            L0 = C2[0];
#else //defined(USE_SPRITE_CACHE)
            L1 = sp2pixel(C+1);
            L0 = sp2pixel(C);
#endif //defined(USE_SPRITE_CACHE)
            
            if (J&M&0x8000) P[0] =PAL((L1>> 4)&15);
            if (J&M&0x4000) P[1] =PAL((L1>>12)&15);
            if (J&M&0x2000) P[2] =PAL((L1>>20)&15);
            if (J&M&0x1000) P[3] =PAL((L1>>28)   );
            if (J&M&0x0800) P[4] =PAL((L1    )&15);
            if (J&M&0x0400) P[5] =PAL((L1>> 8)&15);
            if (J&M&0x0200) P[6] =PAL((L1>>16)&15);
            if (J&M&0x0100) P[7] =PAL((L1>>24)&15);

            if (J&M&0x0080) P[8 ]=PAL((L0>> 4)&15);
            if (J&M&0x0040) P[9 ]=PAL((L0>>12)&15);
            if (J&M&0x0020) P[10]=PAL((L0>>20)&15);
            if (J&M&0x0010) P[11]=PAL((L0>>28)   );
            if (J&M&0x0008) P[12]=PAL((L0    )&15);
            if (J&M&0x0004) P[13]=PAL((L0>> 8)&15);
            if (J&M&0x0002) P[14]=PAL((L0>>16)&15);
            if (J&M&0x0001) P[15]=PAL((L0>>24)&15);
        }
    }
}

static void PutSpriteHflipBack(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,
						  int cx,int cy,int xoffset,int yoffset)

{
	int i,J;
	register unsigned long L0,L1;
    register unsigned long M,MJ;
	int tx;
    byte *CC1=0,*CC2=0,*CC3=0; //byte *CC1,*CC2,*CC3;
	int no;

	yoffset+=8;	// ŏifɓ
	cy--;
	for(i=0;i<h;i++,C+=inc,C2+=inc,P+=WIDTH,yoffset++,CC1+=2,CC2+=2,CC3+=2) {
		if (yoffset>=8) {
			cy++;
			cy = cy&(io.bg_h-1);
			yoffset -= 8;

			no = ((word*)VRAM)[cx+cy*io.bg_w];
			no&=0xFFF;
			CC1 = &VRAM[no*32+yoffset*2];
			tx=(cx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			no&=0xFFF;
			CC2 = &VRAM[no*32+yoffset*2];
			tx=(tx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			no&=0xFFF;
			CC3 = &VRAM[no*32+yoffset*2];
		}

		M=CC1[0]|CC1[1]|CC1[16]|CC1[17];
		M=(M<<8)|CC2[0]|CC2[1]|CC2[16]|CC2[17];
		M=(M<<8)|CC3[0]|CC3[1]|CC3[16]|CC3[17];
		M>>=(8-xoffset);
		//M=~M;

		J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];

        if(J) {
            MJ = M|J;
#if defined(USE_SPRITE_CACHE)
            L0 = C2[0];
            L1 = C2[1];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C);
            L1 = sp2pixel(C+1);
#endif //defined(USE_SPRITE_CACHE)
            
            if ((MJ&0x8001)==0x0001) P[0]=PAL((L0>>24)&15);
            if ((MJ&0x4002)==0x0002) P[1]=PAL((L0>>16)&15);
            if ((MJ&0x2004)==0x0004) P[2]=PAL((L0>> 8)&15);
            if ((MJ&0x1008)==0x0008) P[3]=PAL((L0    )&15);
            if ((MJ&0x0810)==0x0010) P[4]=PAL((L0>>28)   );
            if ((MJ&0x0420)==0x0020) P[5]=PAL((L0>>20)&15);
            if ((MJ&0x0240)==0x0040) P[6]=PAL((L0>>12)&15);
            if ((MJ&0x0180)==0x0080) P[7]=PAL((L0>> 4)&15);

            if ((MJ&0x0180)==0x0100) P[8] =PAL((L1>>24)&15);
            if ((MJ&0x0240)==0x0200) P[9] =PAL((L1>>16)&15);
            if ((MJ&0x0420)==0x0400) P[10]=PAL((L1>> 8)&15);
            if ((MJ&0x0810)==0x0800) P[11]=PAL((L1    )&15);
            if ((MJ&0x1008)==0x1000) P[12]=PAL((L1>>28)   );
            if ((MJ&0x2004)==0x2000) P[13]=PAL((L1>>20)&15);
            if ((MJ&0x4002)==0x4000) P[14]=PAL((L1>>12)&15);
            if ((MJ&0x8001)==0x8000) P[15]=PAL((L1>> 4)&15);
        }
    }
}

#endif // SPRITE_CUSTOMIZE

#ifdef SPRITE_CUSTOMIZE

static void PutSpriteBack2_hflip(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,
						   int cx,int cy,int xoffset,int yoffset,int hflip)
{
	register int i;
    register unsigned long J;
    register unsigned long L0,L1;
	register unsigned long M,MJ;
	register unsigned long CL;
	register int tx;
	register byte *CC1=0,*CC2=0,*CC3=0;
    register unsigned long *CC21=0,*CC22=0,*CC23=0;
	register PALFMT *CR1=0, *CR2=0, *CR3=0;
    register PALFMT *CP=0;
	register int no;
    
	yoffset+=8;	// ŏifɓ
	cy--;
    
    for(i=0;i<h;i++) {
		if (yoffset>=8) {
			cy++;
			cy = cy&(io.bg_h-1);
			yoffset -= 8;

			no = ((word*)VRAM)[cx+cy*io.bg_w];
			CR1 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC1 = &VRAM[no*32+yoffset*2];
			CC21 = &VRAM2[no*8+yoffset];
			tx=(cx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			CR2 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC2 = &VRAM[no*32+yoffset*2];
			CC22 = &VRAM2[no*8+yoffset];
			tx=(tx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			CR3 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC3 = &VRAM[no*32+yoffset*2];
			CC23 = &VRAM2[no*8+yoffset];
		}

		M=CC1[0]|CC1[1]|CC1[16]|CC1[17];
		M=(M<<8)|CC2[0]|CC2[1]|CC2[16]|CC2[17];
		M=(M<<8)|CC3[0]|CC3[1]|CC3[16]|CC3[17];
		M>>=(8-xoffset);

		J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];

        if(J) {
#if defined(USE_SPRITE_CACHE)
            L0 = C2[1];
            L1 = C2[0];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C+1);
            L1 = sp2pixel(C);
#endif //defined(USE_SPRITE_CACHE)

            if(hflip) {
                MJ=M|J;

                if ((MJ&0x8001)==0x0001) P[0]=PAL((L0>>24)&15);
                if ((MJ&0x4002)==0x0002) P[1]=PAL((L0>>16)&15);
                if ((MJ&0x2004)==0x0004) P[2]=PAL((L0>> 8)&15);
                if ((MJ&0x1008)==0x0008) P[3]=PAL((L0    )&15);
                if ((MJ&0x0810)==0x0010) P[4]=PAL((L0>>28)   );
                if ((MJ&0x0420)==0x0020) P[5]=PAL((L0>>20)&15);
                if ((MJ&0x0240)==0x0040) P[6]=PAL((L0>>12)&15);
                if ((MJ&0x0180)==0x0080) P[7]=PAL((L0>> 4)&15);
                
                if ((MJ&0x0180)==0x0100) P[8] =PAL((L1>>24)&15);
                if ((MJ&0x0240)==0x0200) P[9] =PAL((L1>>16)&15);
                if ((MJ&0x0420)==0x0400) P[10]=PAL((L1>> 8)&15);
                if ((MJ&0x0810)==0x0800) P[11]=PAL((L1    )&15);
                if ((MJ&0x1008)==0x1000) P[12]=PAL((L1>>28)   );
                if ((MJ&0x2004)==0x2000) P[13]=PAL((L1>>20)&15);
                if ((MJ&0x4002)==0x4000) P[14]=PAL((L1>>12)&15);
                if ((MJ&0x8001)==0x8000) P[15]=PAL((L1>> 4)&15);
                
                M<<=8-xoffset;
                J<<=xoffset;
                CP=(P-xoffset);
                MJ = M|J;
                
                CL=CC21[0];
                switch(xoffset) {
                  case 0: if((MJ&0x800001)==0x800001) CP[0]=CR1[(CL>> 4)&15];
                  case 1: if((MJ&0x400002)==0x400002) CP[1]=CR1[(CL>>12)&15];
                  case 2: if((MJ&0x200004)==0x200004) CP[2]=CR1[(CL>>20)&15];
                  case 3: if((MJ&0x100008)==0x100008) CP[3]=CR1[(CL>>28)   ];
                  case 4: if((MJ&0x080010)==0x080010) CP[4]=CR1[(CL    )&15];
                  case 5: if((MJ&0x040020)==0x040020) CP[5]=CR1[(CL>> 8)&15];
                  case 6: if((MJ&0x020040)==0x020040) CP[6]=CR1[(CL>>16)&15];
                  default:
                  case 7: if((MJ&0x010080)==0x010080) CP[7]=CR1[(CL>>24)&15];
                }
                
                CL=CC22[0];
                if((MJ&0x8100)==0x8100) CP[8 ]=CR2[(CL>> 4)&15];
                if((MJ&0x4200)==0x4200) CP[9 ]=CR2[(CL>>12)&15];
                if((MJ&0x2400)==0x2400) CP[10]=CR2[(CL>>20)&15];
                if((MJ&0x1800)==0x1800) CP[11]=CR2[(CL>>28)   ];
                if((MJ&0x1800)==0x1800) CP[12]=CR2[(CL    )&15];
                if((MJ&0x2400)==0x2400) CP[13]=CR2[(CL>> 8)&15];
                if((MJ&0x4200)==0x4200) CP[14]=CR2[(CL>>16)&15];
                if((MJ&0x8100)==0x8100) CP[15]=CR2[(CL>>24)&15];
                
                CL=CC23[0];
                switch(xoffset) {
                  default:
                  case 7: if((MJ&0x00400002)==0x00400002) CP[22]=CR3[(CL>>16)&15];
                  case 6: if((MJ&0x00200004)==0x00200004) CP[21]=CR3[(CL>> 8)&15];
                  case 5: if((MJ&0x00100008)==0x00100008) CP[20]=CR3[(CL    )&15];
                  case 4: if((MJ&0x00080010)==0x00080010) CP[19]=CR3[(CL>>28)   ];
                  case 3: if((MJ&0x00040020)==0x00040020) CP[18]=CR3[(CL>>20)&15];
                  case 2: if((MJ&0x00020040)==0x00020040) CP[17]=CR3[(CL>>12)&15];
                  case 1: if((MJ&0x00010080)==0x00010080) CP[16]=CR3[(CL>> 4)&15];
                  case 0: break;
                }
            } else {
                M=~M;
                MJ=M&J;
                
                if (J&M&0x8000) P[0]=PAL((L0>>4)&15);
                if (J&M&0x4000) P[1]=PAL((L0>>12)&15);
                if (J&M&0x2000) P[2]=PAL((L0>>20)&15);
                if (J&M&0x1000) P[3]=PAL((L0>>28));
                if (J&M&0x0800) P[4]=PAL((L0)&15);
                if (J&M&0x0400) P[5]=PAL((L0>>8)&15);
                if (J&M&0x0200) P[6]=PAL((L0>>16)&15);
                if (J&M&0x0100) P[7]=PAL((L0>>24)&15);
                
                if (J&M&0x0080) P[8 ]=PAL((L1>>4)&15);
                if (J&M&0x0040) P[9 ]=PAL((L1>>12)&15);
                if (J&M&0x0020) P[10]=PAL((L1>>20)&15);
                if (J&M&0x0010) P[11]=PAL((L1>>28));
                if (J&M&0x0008) P[12]=PAL((L1)&15);
                if (J&M&0x0004) P[13]=PAL((L1>>8)&15);
                if (J&M&0x0002) P[14]=PAL((L1>>16)&15);
                if (J&M&0x0001) P[15]=PAL((L1>>24)&15);
                
                M<<=8-xoffset;
                M=~M;
                J<<=8-xoffset;
                CL=CC21[0];
                CP=P-xoffset;
                if (xoffset<=0&&(J&M&0x800000)) CP[0]=CR1[(CL>>4)&15];
                if (xoffset<=1&&(J&M&0x400000)) CP[1]=CR1[(CL>>12)&15];
                if (xoffset<=2&&(J&M&0x200000)) CP[2]=CR1[(CL>>20)&15];
                if (xoffset<=3&&(J&M&0x100000)) CP[3]=CR1[(CL>>28)];
                if (xoffset<=4&&(J&M&0x080000)) CP[4]=CR1[(CL)&15];
                if (xoffset<=5&&(J&M&0x040000)) CP[5]=CR1[(CL>>8)&15];
                if (xoffset<=6&&(J&M&0x020000)) CP[6]=CR1[(CL>>16)&15];
                if (            (J&M&0x010000)) CP[7]=CR1[(CL>>24)&15];
                
                CL=CC22[0];
                if (J&M&0x8000) CP[8 ]=CR2[(CL>>4)&15];
                if (J&M&0x4000) CP[9 ]=CR2[(CL>>12)&15];
                if (J&M&0x2000) CP[10]=CR2[(CL>>20)&15];
                if (J&M&0x1000) CP[11]=CR2[(CL>>28)];
                if (J&M&0x0800) CP[12]=CR2[(CL)&15];
                if (J&M&0x0400) CP[13]=CR2[(CL>>8)&15];
                if (J&M&0x0200) CP[14]=CR2[(CL>>16)&15];
                if (J&M&0x0100) CP[15]=CR2[(CL>>24)&15];
                
                CL=CC23[0];
                if (xoffset>=1&&(J&M&0x80)) CP[16]=CR3[(CL>>4)&15];
                if (xoffset>=2&&(J&M&0x40)) CP[17]=CR3[(CL>>12)&15];
                if (xoffset>=3&&(J&M&0x20)) CP[18]=CR3[(CL>>20)&15];
                if (xoffset>=4&&(J&M&0x10)) CP[19]=CR3[(CL>>28)];
                if (xoffset>=5&&(J&M&0x08)) CP[20]=CR3[(CL)&15];
                if (xoffset>=6&&(J&M&0x04)) CP[21]=CR3[(CL>>8)&15];
                if (xoffset>=7&&(J&M&0x02)) CP[22]=CR3[(CL>>16)&15];
            }
        }

        C+=inc;
        C2+=inc;
        P+=WIDTH;
        yoffset++;
        CC1+=2;
        CC2+=2;
        CC3+=2;
        CC21++;
        CC22++;
        CC23++;
    }
}

#else// SPRITE_CUSTOMIZE
static void PutSpriteBack2(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,
						   int cx,int cy,int xoffset,int yoffset)
{
	int i;
	unsigned long J;
	register unsigned long L0,L1;
	unsigned long M;
	unsigned long CL;
	int tx;
#if 0 
	byte *CC1,*CC2,*CC3;
	unsigned long *CC21,*CC22,*CC23;
	PALFMT *CR1, *CR2, *CR3;
    PALFMT *CP;
#else// warninĝŏ
	byte *CC1=0,*CC2=0,*CC3=0;
	unsigned long *CC21=0,*CC22=0,*CC23=0;
	PALFMT *CR1=0, *CR2=0, *CR3=0;
    PALFMT *CP=0;
#endif
	int no;
    
	yoffset+=8;	// ŏifɓ
	cy--;
	for(i=0;i<h;i++,C+=inc,C2+=inc,P+=WIDTH,yoffset++,CC1+=2,CC2+=2,CC3+=2,CC21++,CC22++,CC23++) {
		if (yoffset>=8) {
			cy++;
			cy = cy&(io.bg_h-1);
			yoffset -= 8;

			no = ((word*)VRAM)[cx+cy*io.bg_w];
			CR1 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC1 = &VRAM[no*32+yoffset*2];
			CC21 = &VRAM2[no*8+yoffset];
			tx=(cx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			CR2 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC2 = &VRAM[no*32+yoffset*2];
			CC22 = &VRAM2[no*8+yoffset];
			tx=(tx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			CR3 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC3 = &VRAM[no*32+yoffset*2];
			CC23 = &VRAM2[no*8+yoffset];
		}

		M=CC1[0]|CC1[1]|CC1[16]|CC1[17];
		M=(M<<8)|CC2[0]|CC2[1]|CC2[16]|CC2[17];
		M=(M<<8)|CC3[0]|CC3[1]|CC3[16]|CC3[17];
		M>>=(8-xoffset);
		M=~M;

		J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];

        if(J) {
#if defined(USE_SPRITE_CACHE)
            L0 = C2[1];
            L1 = C2[0];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C+1);
            L1 = sp2pixel(C);
#endif //defined(USE_SPRITE_CACHE)
            
            if (J&M&0x8000) P[0]=PAL((L0>>4)&15);
            if (J&M&0x4000) P[1]=PAL((L0>>12)&15);
            if (J&M&0x2000) P[2]=PAL((L0>>20)&15);
            if (J&M&0x1000) P[3]=PAL((L0>>28));
            if (J&M&0x0800) P[4]=PAL((L0)&15);
            if (J&M&0x0400) P[5]=PAL((L0>>8)&15);
            if (J&M&0x0200) P[6]=PAL((L0>>16)&15);
            if (J&M&0x0100) P[7]=PAL((L0>>24)&15);
            
            if (J&M&0x80) P[8 ]=PAL((L1>>4)&15);
            if (J&M&0x40) P[9 ]=PAL((L1>>12)&15);
            if (J&M&0x20) P[10]=PAL((L1>>20)&15);
            if (J&M&0x10) P[11]=PAL((L1>>28));
            if (J&M&0x08) P[12]=PAL((L1)&15);
            if (J&M&0x04) P[13]=PAL((L1>>8)&15);
            if (J&M&0x02) P[14]=PAL((L1>>16)&15);
            if (J&M&0x01) P[15]=PAL((L1>>24)&15);
            
            M<<=8-xoffset;
            M=~M;
            J<<=8-xoffset;
            CL=CC21[0];
            CP=P-xoffset;
            /*switch (xoffset) {
		case 0: if (J&M&0x800000) CP[0]=CR1[(CL>>4)&15];
		case 1: if (J&M&0x400000) CP[1]=CR1[(CL>>12)&15];
		case 2: if (J&M&0x200000) CP[2]=CR1[(CL>>20)&15];
		case 3: if (J&M&0x100000) CP[3]=CR1[(CL>>28)];
		case 4: if (J&M&0x080000) CP[4]=CR1[(CL)&15];
		case 5: if (J&M&0x040000) CP[5]=CR1[(CL>>8)&15];
		case 6: if (J&M&0x020000) CP[6]=CR1[(CL>>16)&15];
		case 7: if (J&M&0x010000) CP[7]=CR1[(CL>>24)&15];
		}*/
            if (xoffset<=0&&(J&M&0x800000)) CP[0]=CR1[(CL>>4)&15];
            if (xoffset<=1&&(J&M&0x400000)) CP[1]=CR1[(CL>>12)&15];
            if (xoffset<=2&&(J&M&0x200000)) CP[2]=CR1[(CL>>20)&15];
            if (xoffset<=3&&(J&M&0x100000)) CP[3]=CR1[(CL>>28)];
            if (xoffset<=4&&(J&M&0x080000)) CP[4]=CR1[(CL)&15];
            if (xoffset<=5&&(J&M&0x040000)) CP[5]=CR1[(CL>>8)&15];
            if (xoffset<=6&&(J&M&0x020000)) CP[6]=CR1[(CL>>16)&15];
            if (            (J&M&0x010000)) CP[7]=CR1[(CL>>24)&15];
            CL=CC22[0];
            if (J&M&0x8000) CP[8 ]=CR2[(CL>>4)&15];
            if (J&M&0x4000) CP[9 ]=CR2[(CL>>12)&15];
            if (J&M&0x2000) CP[10]=CR2[(CL>>20)&15];
            if (J&M&0x1000) CP[11]=CR2[(CL>>28)];
            if (J&M&0x0800) CP[12]=CR2[(CL)&15];
            if (J&M&0x0400) CP[13]=CR2[(CL>>8)&15];
            if (J&M&0x0200) CP[14]=CR2[(CL>>16)&15];
            if (J&M&0x0100) CP[15]=CR2[(CL>>24)&15];
            CL=CC23[0];
            /*switch (xoffset) {
		case  7: if (J&M&0x02) CP[22]=CR3[(CL>>16)&15];
		case  6: if (J&M&0x04) CP[21]=CR3[(CL>>8)&15];
		case  5: if (J&M&0x08) CP[20]=CR3[(CL)&15];
		case  4: if (J&M&0x10) CP[19]=CR3[(CL>>28)];
		case  3: if (J&M&0x20) CP[18]=CR3[(CL>>20)&15];
		case  2: if (J&M&0x40) CP[17]=CR3[(CL>>12)&15];
		case  1: if (J&M&0x80) CP[16]=CR3[(CL>>4)&15];
		}*/
            if (xoffset>=1&&(J&M&0x80)) CP[16]=CR3[(CL>>4)&15];
            if (xoffset>=2&&(J&M&0x40)) CP[17]=CR3[(CL>>12)&15];
            if (xoffset>=3&&(J&M&0x20)) CP[18]=CR3[(CL>>20)&15];
            if (xoffset>=4&&(J&M&0x10)) CP[19]=CR3[(CL>>28)];
            if (xoffset>=5&&(J&M&0x08)) CP[20]=CR3[(CL)&15];
            if (xoffset>=6&&(J&M&0x04)) CP[21]=CR3[(CL>>8)&15];
            if (xoffset>=7&&(J&M&0x02)) CP[22]=CR3[(CL>>16)&15];
        }
	}
}

static void PutSpriteHflipBack2(PALFMT *P,byte *C,unsigned long *C2,PALFMT *R,int h,int inc,
								int cx,int cy,int xoffset,int yoffset)
{
	register int i;
    register unsigned long J;
    register unsigned long M;
    register unsigned long CL;
    register byte *CC1=0,*CC2=0,*CC3=0;
    register unsigned long *CC21=0,*CC22=0,*CC23=0;
    register PALFMT *CR1=0, *CR2=0, *CR3=0;
    register PALFMT *CP;
    register int no;

	yoffset+=8;	// ŏifɓ
	cy--;
	for(i=0;i<h;i++) {
		if (yoffset>=8) {
            register int tx;
			cy++;
			cy = cy&(io.bg_h-1);
			yoffset -= 8;

			no = ((word*)VRAM)[cx+cy*io.bg_w];
			CR1 = &huePal[(no>>12)*16];
            no&=0xFFF;
			CC1 = &VRAM[no*32+yoffset*2];
			CC21 = &VRAM2[no*8+yoffset];
			tx=(cx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			CR2 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC2 = &VRAM[no*32+yoffset*2];
			CC22 = &VRAM2[no*8+yoffset];
			tx=(tx+1)&(io.bg_w-1);
			no = ((word*)VRAM)[tx+cy*io.bg_w];
			CR3 = &huePal[(no>>12)*16];
			no&=0xFFF;
			CC3 = &VRAM[no*32+yoffset*2];
			CC23 = &VRAM2[no*8+yoffset];
		}

		M=CC1[0]|CC1[1]|CC1[16]|CC1[17];
		M=(M<<8)|CC2[0]|CC2[1]|CC2[16]|CC2[17];
		M=(M<<8)|CC3[0]|CC3[1]|CC3[16]|CC3[17];
		M>>=(8-xoffset);

		J = ((word*)C)[0]|((word*)C)[16]|((word*)C)[32]|((word*)C)[48];

        if(J) {
            register int MJ = M|J;
            register unsigned long L0,L1;
            
#if defined(USE_SPRITE_CACHE)
            L0 = C2[0];
            L1 = C2[1];
#else //defined(USE_SPRITE_CACHE)
            L0 = sp2pixel(C);
            L1 = sp2pixel(C+1);
#endif //defined(USE_SPRITE_CACHE)
            
            if ((MJ&0x8001)==0x0001) P[0]=PAL((L0>>24)&15);
            if ((MJ&0x4002)==0x0002) P[1]=PAL((L0>>16)&15);
            if ((MJ&0x2004)==0x0004) P[2]=PAL((L0>> 8)&15);
            if ((MJ&0x1008)==0x0008) P[3]=PAL((L0    )&15);
            if ((MJ&0x0810)==0x0010) P[4]=PAL((L0>>28)   );
            if ((MJ&0x0420)==0x0020) P[5]=PAL((L0>>20)&15);
            if ((MJ&0x0240)==0x0040) P[6]=PAL((L0>>12)&15);
            if ((MJ&0x0180)==0x0080) P[7]=PAL((L0>> 4)&15);

            if ((MJ&0x0180)==0x0100) P[8] =PAL((L1>>24)&15);
            if ((MJ&0x0240)==0x0200) P[9] =PAL((L1>>16)&15);
            if ((MJ&0x0420)==0x0400) P[10]=PAL((L1>> 8)&15);
            if ((MJ&0x0810)==0x0800) P[11]=PAL((L1    )&15);
            if ((MJ&0x1008)==0x1000) P[12]=PAL((L1>>28)   );
            if ((MJ&0x2004)==0x2000) P[13]=PAL((L1>>20)&15);
            if ((MJ&0x4002)==0x4000) P[14]=PAL((L1>>12)&15);
            if ((MJ&0x8001)==0x8000) P[15]=PAL((L1>> 4)&15);

            
            M<<=8-xoffset;
            J<<=xoffset;
            CP=(P-xoffset);
            MJ = M|J;

            CL=CC21[0];
            if(MJ&0x00FF00FF) {
                switch(xoffset) {
                  case 0: if((MJ&0x800001)==0x800001) CP[0]=CR1[(CL>> 4)&15];
                  case 1: if((MJ&0x400002)==0x400002) CP[1]=CR1[(CL>>12)&15];
                  case 2: if((MJ&0x200004)==0x200004) CP[2]=CR1[(CL>>20)&15];
                  case 3: if((MJ&0x100008)==0x100008) CP[3]=CR1[(CL>>28)   ];
                  case 4: if((MJ&0x080010)==0x080010) CP[4]=CR1[(CL    )&15];
                  case 5: if((MJ&0x040020)==0x040020) CP[5]=CR1[(CL>> 8)&15];
                  case 6: if((MJ&0x020040)==0x020040) CP[6]=CR1[(CL>>16)&15];
                  default:
                  case 7: if((MJ&0x010080)==0x010080) CP[7]=CR1[(CL>>24)&15];
                }
            }
            
            CL=CC22[0];
            if(MJ&0x0000FF00) {
                if((MJ&0x8100)==0x8100) CP[8 ]=CR2[(CL>> 4)&15];
                if((MJ&0x4200)==0x4200) CP[9 ]=CR2[(CL>>12)&15];
                if((MJ&0x2400)==0x2400) CP[10]=CR2[(CL>>20)&15];
                if((MJ&0x1800)==0x1800) CP[11]=CR2[(CL>>28)   ];
                if((MJ&0x1800)==0x1800) CP[12]=CR2[(CL    )&15];
                if((MJ&0x2400)==0x2400) CP[13]=CR2[(CL>> 8)&15];
                if((MJ&0x4200)==0x4200) CP[14]=CR2[(CL>>16)&15];
                if((MJ&0x8100)==0x8100) CP[15]=CR2[(CL>>24)&15];
            }
            
            CL=CC23[0];
            if(MJ & 0x00FF00FF) {
                switch(xoffset) {
                  default:
                  case 7: if((MJ&0x00400002)==0x00400002) CP[22]=CR3[(CL>>16)&15];
                  case 6: if((MJ&0x00200004)==0x00200004) CP[21]=CR3[(CL>> 8)&15];
                  case 5: if((MJ&0x00100008)==0x00100008) CP[20]=CR3[(CL    )&15];
                  case 4: if((MJ&0x00080010)==0x00080010) CP[19]=CR3[(CL>>28)   ];
                  case 3: if((MJ&0x00040020)==0x00040020) CP[18]=CR3[(CL>>20)&15];
                  case 2: if((MJ&0x00020040)==0x00020040) CP[17]=CR3[(CL>>12)&15];
                  case 1: if((MJ&0x00010080)==0x00010080) CP[16]=CR3[(CL>> 4)&15];
                  case 0: break;
                }
            }
        }
        C+=inc;
        C2+=inc;
        P+=WIDTH;
        yoffset++;
        CC1+=2;
        CC2+=2;
        CC3+=2;
        CC21++;
        CC22++;
        CC23++;
    }
}
#endif // SPRITE_CUSTOMIZE

//
//
//
void RefreshSprite(int Y1,int Y2)
{
	int n;
	SPR *spr;
	int usespbg = 0;

	spr = (SPR*)SPRAM + 63;

	for(n=0;n<64;n++,spr--) {
		int x,y,no,atr,inc,cgx,cgy;
        PALFMT *R;
        byte *C;
        unsigned long *C2;
		int	pos;
		int h,t,i,j;
		int y_sum;
		int spbg;
		int cx;
		int cy;
		int yoffset;
		int xoffset;
		int tx;

		atr=spr->atr;
		spbg = (atr>>7)&1;
		//if (spbg != bg)
		//	continue;
		y = (spr->y&1023)-64;       // x coordinate    (10bit)
		x = (spr->x&1023)-32;       // y coordinate    (10bit)
		no= spr->no&2047;           // Pattern address (10bit)
		cgx = (atr>>8)&1;           // SPRITE-W (0:16,1:32)
		cgy = (atr>>12)&3;          // SPRITE-H (00:16,01:32,10:Inv,11:64)
		cgy |= cgy>>1;              // 
		no = (no>>1)&~(cgy*2+cgx);  // 
        
		if (y>=Y2 || y+(cgy+1)*16<Y1 || x>=FC_W || x+(cgx+1)*16<0) continue;

        // pbg̃AhX擾
		R = &SPal[(atr&15)*16];
        
#if defined(USE_SPRITE_CACHE)
		for (i=0;i<cgy*2+cgx+1;i++) {
			if (vchanges[no+i]) {
				vchanges[no+i] = 0;
				sprite2pixel(no+i);
			}
			if (!cgx) i++;
		}
#endif //defined(USE_SPRITE_CACHE)
        
		C = &VRAM[no*128];
        
#if defined(USE_SPRITE_CACHE)
		C2 = &VRAMS[no*32];
#else //defined(USE_SPRITE_CACHE)
		C2 = (unsigned long *)VRAM;//NULL;
#endif //defined(USE_SPRITE_CACHE)
        
		pos = WIDTH*(HEIGHT-FC_H)/2+(WIDTH-FC_W)/2+WIDTH*y+x;
		inc = 2;
		if (atr&V_FLIP) { inc=-2; C+=15*2+cgy*256; C2+=15*2+cgy*64;}
		y_sum = 0;
		//printf("(%d,%d,%d,%d,%d)",x,y,cgx,cgy,h);
		//TRACE("Spr#%d,no=%d,x=%d,y=%d,CGX=%d,CGY=%d,xb=%d,yb=%d\n", n, no, x, y, cgx, cgy, atr&H_FLIP, atr&V_FLIP);

		cy = y+ScrollY-ScrollYDiff;
		yoffset = cy&7;
		cy>>=3;
		xoffset=(x+ScrollX)&7;
		cx = (x+ScrollX)/8;

		for(i=0;i<=cgy;i++) {
			cy = cy&(io.bg_h-1);
			t = Y1-y-y_sum;
			h = 16;
			if (t>0) {
				C+=t*inc;
				C2+=t*inc;
				h-=t;
				pos+=t*WIDTH;
				cy+=(yoffset+t)>>3;
				yoffset=(yoffset+t)&7;
			}
			if (h>Y2-y-y_sum) h = Y2-y-y_sum;
            
			if (spbg==1 || !ScreenON){
#ifdef SPRITE_CUSTOMIZE
                PALFMT *p;
                int hflip = (atr&H_FLIP);
				usespbg=1;
                for(j=0;j<=cgx;j++) {
                    if(hflip) p = XBuf+pos+(cgx-j)*16;
                    else      p = XBuf+pos+j*16;
                    PutSprite_hflip(p,C+j*128,C2+j*32,R,h,inc,hflip);
                }
#else//SPRITE_CUSTOMIZE
				usespbg=1;
				if (atr&H_FLIP){
				  for(j=0;j<=cgx;j++)
                    PutSpriteHflip(XBuf+pos+(cgx-j)*16,C+j*128,C2+j*32,R,h,inc);
				}else{
				  for(j=0;j<=cgx;j++)
					PutSprite(XBuf+pos+j*16,C+j*128,C2+j*32,R,h,inc);
				}
#endif//SPRITE_CUSTOMIZE
			} else if (usespbg) {
#ifdef SPRITE_CUSTOMIZE
                int hflip=atr&H_FLIP;
                void *p1,*p2;
                if(hflip) { p1 = C+(cgx-j)*128; p2=C2+(cgx-j)*32; }
                else      { p1 = C+     j *128, p2=C2+     j *32; }

                for(j=0,tx=cx;j<=cgx;j++,tx+=2) {
                    tx&=io.bg_w-1;
                    PutSpriteBack2_hflip(XBuf+pos+j*16,p1,p2,R,h,inc,tx,cy,xoffset,yoffset,hflip);
                }
                
#else//SPRITE_CUSTOMIZE
				if (atr&H_FLIP){
					for(j=0,tx=cx;j<=cgx;j++,tx+=2) {
						tx&=io.bg_w-1;
						PutSpriteHflipBack2(XBuf+pos+j*16,C+(cgx-j)*128,C2+(cgx-j)*32,R,h,inc,tx,cy,xoffset,yoffset);
					}
				}else{
					for(j=0,tx=cx;j<=cgx;j++,tx+=2) {
						tx&=io.bg_w-1;
						PutSpriteBack2(XBuf+pos+j*16,C+j*128,C2+j*32,R,h,inc,tx,cy,xoffset,yoffset);
					}
				}
#endif//SPRITE_CUSTOMIZE
			} else {
#ifdef SPRITE_CUSTOMIZE
                int hflip = atr & H_FLIP;
                void *p1,*p2;
                
                for(j=0,tx=cx;j<=cgx;j++,tx+=2) {
                    tx&=io.bg_w-1;
                    if(hflip) { p1 = C+(cgx-j)*128; p2=C2+(cgx-j)*32; }
                    else      { p1 = C+     j *128, p2=C2+     j *32; }
                    PutSpriteBack_hflip(XBuf+pos+j*16,p1,p2,R,h,inc,tx,cy,xoffset,yoffset,hflip);
                    //PutSpriteBack_hflip
                    //PutSpriteHflipBack(XBuf+pos+j*16,C+(cgx-j)*128,C2+(cgx-j)*32,R,h,inc,tx,cy,xoffset,yoffset);
                    //PutSpriteBack     (XBuf+pos+j*16,C+     j *128,C2+     j *32,R,h,inc,tx,cy,xoffset,yoffset);
                }
#else//SPRITE_CUSTOMIZE
				if (atr&H_FLIP){
					for(j=0,tx=cx;j<=cgx;j++,tx+=2) {
						tx&=io.bg_w-1;
						PutSpriteHflipBack(XBuf+pos+j*16,C+(cgx-j)*128,C2+(cgx-j)*32,R,h,inc,tx,cy,xoffset,yoffset);
					}
				}else{
					for(j=0,tx=cx;j<=cgx;j++,tx+=2) {
						tx&=io.bg_w-1;
						PutSpriteBack(XBuf+pos+j*16,C+j*128,C2+j*32,R,h,inc,tx,cy,xoffset,yoffset);
					}
				}
#endif//SPRITE_CUSTOMIZE
			}
            
			pos+=h*WIDTH;
			C+=h*inc+16*7*inc;
			C2+=h*inc+16*inc;
			y_sum+=16;
			cy+=(yoffset+h)>>3;
			yoffset=(yoffset+h)&7;
		}
	}
}

void RefreshScreen(void)
{
	int dispmin,dispmax;

	dispmin = (MaxLine-MinLine>MAXDISP ? MinLine+((MaxLine-MinLine-MAXDISP+1)>>1) : MinLine);
	dispmax = (MaxLine-MinLine>MAXDISP ? MaxLine-((MaxLine-MinLine-MAXDISP+1)>>1) : MaxLine);

    PutImage((WIDTH-FC_W)/2,(HEIGHT-FC_H)/2+MinLine+dispmin,FC_W,dispmax-dispmin+1);

    //memset(XBuf+MinLine*WIDTH,huePal[0],(MaxLine-MinLine)*WIDTH);
	//memset(SPM+MinLine*WIDTH,0,(MaxLine-MinLine)*WIDTH);
    // frame skip work
    frame_skip();
}

void ResetPCE(M6502 *M)
{
    int i;

    _memset(M,0,sizeof(*M));
	TimerCount = TimerPeriod;
	M->IPeriod = IPeriod;
	M->TrapBadOps = 1;
	_memset(&io, 0, sizeof(IO));
	scanline = 0;
	prevline = 0;
	io.vdc_status=0;//VDC_InVBlank;
	io.vdc_inc = 1;
	io.minline = 0;
	io.maxline = 255;
	io.irq_mask = 0;

#if 1
	io.psg_volume = 0;
	io.psg_ch = 0;
    for(i=0;i<8;i++) { io.PSG[i][4] = 0x80; }
#endif

    
	for(i=0;i<5;i++) { io.shiftmode[i] = 0; }
	CycleOld = 0;
	Reset6502(M);
}

int InitPCE(char *name, char *backmemname)
{
	int i,ROMmask;

    IPeriod = BaseClock/(scanlines_per_frame*60);
	TimerPeriod = BaseClock/1000*3*1024/21480;

    if(!CartLoad(name)) {
        return 0;
    }
    populus = 0;
    
	if(ROM_size > 256)
		sf2ce = 1;
	else
		sf2ce = 0;

	_memset(DMYROM,NODATA,0x2000);
	_memset(WRAM,0,0x2000);
	_memset(IOAREA,0xFF,0x2000);
	_memset(vchange,1,VRAMSIZE/32);

#ifdef USE_SPRITE_CACHE
	_memset(vchanges,1,VRAMSIZE/128);
#endif //USE_SPRITE_CACHE

    
#ifdef CDEMULATION
    CD_init();
#endif
    
	ROMmask = 1;
	while(ROMmask<ROM_size) ROMmask<<=1;
	ROMmask--;
    //TRACE("ROMmask=%02X, ROM_size=%02X\n", ROMmask, ROM_size);

    for(i=0;i<0xF7;i++) {
        if (ROM_size == 0x30) {
			switch (i&0x70) {
			case 0x00:
			case 0x10:
			case 0x50:
				ROMMap[i]=ROM+(i&ROMmask)*0x2000;
				break;
			case 0x20:
			case 0x60:
				ROMMap[i]=ROM+((i-0x20)&ROMmask)*0x2000;;
				break;
			case 0x30:
			case 0x70:
				ROMMap[i]=ROM+((i-0x10)&ROMmask)*0x2000;
				break;
			case 0x40:
				ROMMap[i]=ROM+((i-0x20)&ROMmask)*0x2000;
				break;
			}
		}
        else {
			ROMMap[i]=ROM+(i&ROMmask)*0x2000;
        }
	}
    
//		ROMMap[i]=ROM+(i%ROM_size+i/ROM_size*0x10)*0x2000;
/*		if (((i&ROMmask)+i/(ROMmask+1)) < ROM_size)
			ROMMap[i]=ROM+((i&ROMmask)+i/(ROMmask+1)*0x20)*0x2000;
		else
			ROMMap[i]=ROM;
*///		ROMMap[i]=ROM+(i&ROMmask)*0x2000;
   
	if (populus) {
		ROMMap[0x40] = PopRAM + (0)*0x2000;
		ROMMap[0x41] = PopRAM + (1)*0x2000;
		ROMMap[0x42] = PopRAM + (2)*0x2000;
		ROMMap[0x43] = PopRAM + (3)*0x2000;
	}

#ifdef CDEMULATION
	if (1) {
		for(i = 0; i < 8; i++)
          _memcpy(cd_extra_mem + i * 0x2000, ROMMap[0x80 + i], 0x2000);
        
        ROMMap[0x80] = cd_extra_mem;
        ROMMap[0x81] = cd_extra_mem + 0x2000;
        ROMMap[0x82] = cd_extra_mem + 0x4000;
        ROMMap[0x83] = cd_extra_mem + 0x6000;
        ROMMap[0x84] = cd_extra_mem + 0x8000;
        ROMMap[0x85] = cd_extra_mem + 0xA000;
        ROMMap[0x86] = cd_extra_mem + 0xC000;
        ROMMap[0x87] = cd_extra_mem + 0xE000;

        for(i=0x68;i<0x80;i++) {
            _memcpy(cd_extra_super_mem+0x2000*(i-0x68),ROMMap[i], 0x2000);
			ROMMap[i] = cd_extra_super_mem+0x2000*(i-0x68);
		}
	}
#endif // CDEMULATION
   
/*	ROMMap[0x80] = PopRAM + (0)*0x2000;
	ROMMap[0x81] = PopRAM + (1)*0x2000;
	ROMMap[0x82] = PopRAM + (2)*0x2000;
	ROMMap[0x83] = PopRAM + (3)*0x2000;
	ROMMap[0x84] = PopRAM + (4)*0x2000;
	ROMMap[0x85] = PopRAM + (5)*0x2000;
	ROMMap[0x86] = PopRAM + (6)*0x2000;
	ROMMap[0x87] = PopRAM + (7)*0x2000;
*/	ROMMap[0xF7]=WRAM;
	ROMMap[0xF8]=RAM;
	ROMMap[0xF9]=RAM+0x2000;
	ROMMap[0xFA]=RAM+0x4000;
	ROMMap[0xFB]=RAM+0x6000;
	ROMMap[0xFF]=IOAREA; //NULL; /* NULL = I/O area */
#if 0x000000
	FILE *fp;
	fp = fopen(backmemname, "rb");
	if (fp == NULL)
		LogDump("Can't open %s\n", backmemname);
	else
	{
		fread(WRAM, 0x2000, 1, fp);
		fclose(fp);
	}
#endif // 0x00000000
	return 1;
}
   
void loadWRAM(void);
void saveWRAM(void);
   
int RunPCE(void)
{
	ResetPCE(&M);
    loadWRAM();
	Run6502(&M);
    saveWRAM();
    return 1;
}

